package systems.dennis.shared.mongo.specification;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Repository;
import systems.dennis.shared.mongo.service.StringIdEntity;
import systems.dennis.shared.mongo.repository.MongoSpecification;
import systems.dennis.shared.repository.AbstractDataFilter;

import java.util.List;
import java.util.Optional;

@Repository
public interface MongoSpecificationExecutor<T extends StringIdEntity> {

    /**
     * Returns a single entity matching the given {@link MongoSpecification} or {@link Optional#empty()} if none found.
     *
     * @param spec can be {@literal null}.
     * @return never {@literal null}.
     * @throws org.springframework.dao.IncorrectResultSizeDataAccessException if more than one entity found.
     */
    Optional<T> filteredOne(@Nullable AbstractDataFilter<?> spec);
    Optional<T> filteredFirst(@Nullable AbstractDataFilter<?> spec);

    /**
     * Returns all entities matching the given {@link MongoSpecification}.
     *
     * @param spec can be {@literal null}.
     * @return never {@literal null}.
     */
    Page<T> filteredData(@Nullable AbstractDataFilter<?> spec);

    /**
     * Returns a {@link Page} of entities matching the given {@link MongoSpecification}.
     *
     * @param spec     can be {@literal null}.
     * @param pageable must not be {@literal null}.
     * @return never {@literal null}.
     */
    Page<T> filteredData(@Nullable AbstractDataFilter<?> spec, Pageable pageable);

    /**
     * Returns all entities matching the given {@link MongoSpecification} and {@link Sort}.
     *
     * @param spec can be {@literal null}.
     * @param sort must not be {@literal null}.
     * @return never {@literal null}.
     */
    List<T> filteredData(@Nullable AbstractDataFilter<?> spec, Sort sort);

    /**
     * Returns the number of instances that the given {@link MongoSpecification} will return.
     *
     * @param spec the {@link MongoSpecification} to count instances for. Can be {@literal null}.
     * @return the number of instances.
     */
    long filteredCount(@Nullable AbstractDataFilter<?> spec);
}
