package systems.dennis.shared.mongo.form;

import lombok.Data;
import systems.dennis.shared.annotations.Validation;
import systems.dennis.shared.pojo_form.Checkable;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.UIAction;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.pojo_view.list.Remote;
import systems.dennis.shared.validation.FieldIsUniqueValidator;

import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.*;

@Data
@PojoListView(actions = {"download", "new", "settings"})
public class LanguageForm implements DefaultForm {

    @PojoFormElement(type = HIDDEN)
    private String id;

    @PojoFormElement(required = true)
    @PojoListViewField(searchable = true)
    @Validation(FieldIsUniqueValidator.class)
    private String name;
    @PojoFormElement(required = true, type = FILE, remote = @Remote(searchType = FILE))
    @PojoListViewField(searchable = false, sortable = false)
    @Validation(FieldIsUniqueValidator.class)
    private String icon;

    @PojoFormElement(required = true)
    @PojoListViewField(searchable = true)
    private String code;

    @PojoFormElement (checked = @Checkable, type = CHECKBOX, remote = @Remote(searchType = CHECKBOX))
    @PojoListViewField (type = CHECKBOX, remote = @Remote(searchType = CHECKBOX))
    private Boolean active;

    @PojoListViewField(actions = {@UIAction(component = "edit"), @UIAction(component = "delete")}, sortable = false)
    @PojoFormElement(available = false)
    private Integer action;

    @Override
    public String asValue() {
        return name;
    }
}
