package systems.dennis.shared.mongo.controller;

import lombok.SneakyThrows;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import systems.dennis.shared.controller.items.AbstractGetByIdController;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.mongo.form.DefaultForm;
import systems.dennis.shared.mongo.service.StringIdEntity;

public interface GetByIdController<DB_TYPE extends StringIdEntity, FORM extends DefaultForm> extends AbstractGetByIdController<DB_TYPE, FORM,  String > {
    @SneakyThrows
    @GetMapping("/id/{id}")
    @ResponseBody
    default ResponseEntity<FORM> get(@PathVariable("id") String id) {
        DB_TYPE type = (DB_TYPE) getService().findById(id).orElseThrow(() -> ItemNotFoundException.fromId(id));
        if (type == null){
            throw ItemNotFoundException.fromId(id);
        }
        return ResponseEntity.ok(toForm(type));
    }
}
