package systems.dennis.shared.mongo.bean;

import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.beans.AbstractEditDeleteHistoryBean;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.mongo.service.StringIdEntity;
import systems.dennis.shared.exceptions.DeleteNotPossibleException;
import systems.dennis.shared.exceptions.ItemWasDeletedException;
import systems.dennis.shared.mongo.model.DeleteHistoryModel;
import systems.dennis.shared.mongo.model.EditHistoryModel;
import systems.dennis.shared.mongo.service.DeleteHistoryService;
import systems.dennis.shared.mongo.service.EditHistoryService;

import java.util.Date;

import static systems.dennis.shared.utils.Mapper.mapper;

@Slf4j @Service @Primary
public class MongoSaveEditDeleteHistory extends AbstractEditDeleteHistoryBean<StringIdEntity, String> {
    public MongoSaveEditDeleteHistory(WebContext context) {
        super(context);
    }

    @Override
    public void edit(StringIdEntity from, StringIdEntity to) {
        var editableObject = EditHistoryModel.from(from, to);
        getContext().getBean(EditHistoryService.class).save(editableObject);
    }

    @Override
    public void delete(String id, StringIdEntity model) {

        if (id == null || model == null){
            throw new DeleteNotPossibleException("id_or_model_are_null", id);
        }
        try {
            DeleteHistoryModel deleteHistoryModel = new DeleteHistoryModel();
            deleteHistoryModel.setDeletedDate(new Date());
            deleteHistoryModel.setContent(mapper.writeValueAsString(model));
            deleteHistoryModel.setClassDeletedObject(model.getClass().getSimpleName());

            var deletedObjectExists = getBean(DeleteHistoryService.class).existsByTypeAndDeletedId(id,
                    this.getClass().getAnnotation(DataRetrieverDescription.class).model().getSimpleName());
            if (deletedObjectExists) {
                throw new ItemWasDeletedException(id, model.getClass());
            }
        } catch (Exception e){
            log.debug("cannot save object history: ", e);
        }

    }

    @Override
    public void throwIfDeleted(String id, Class model) {
        if (model == null || id == null) return;
        var deletedObjectExists = getBean(DeleteHistoryService.class).existsByTypeAndDeletedId(id,
                model.getSimpleName());
        if (deletedObjectExists) {
            throw new ItemWasDeletedException(id, model.getClass().getSuperclass());
        }
    }
}
