package systems.dennis.shared.mongo.repository.query_processors;

import lombok.extern.slf4j.Slf4j;
import org.springframework.data.mongodb.core.query.Criteria;
import systems.dennis.shared.repository.AbstractDataFilter;

import java.text.SimpleDateFormat;

import static systems.dennis.shared.utils.bean_copier.DateAndStringConverter.DEFAULT_DATE_TEMPLATE;


@Slf4j
public class DatePredicateProcessor extends AbstractClassProcessor {
    public static final SimpleDateFormat formatter = new SimpleDateFormat(DEFAULT_DATE_TEMPLATE);
    public DatePredicateProcessor(AbstractDataFilter<?> queryCase, Criteria root) {
        super(queryCase, root);
    }

    @Override
    public Object getValue(Object value) {

        try {
            value = formatter.parse(String.valueOf(getFilter().getValue()));
        } catch (Exception e) {
            log.warn("Search is not able to parse date: " + value, e);
            return null;
        }

        return value;
    }
}


