package systems.dennis.shared.mongo.service;

import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.mongo.form.EditHistoryForm;
import systems.dennis.shared.mongo.model.EditHistoryModel;
import systems.dennis.shared.mongo.repository.EditHistoryRepo;
import systems.dennis.shared.mongo.repository.MongoSpecification;

import java.util.List;
import java.util.Optional;

@Service
@DataRetrieverDescription(model = EditHistoryModel.class, form = EditHistoryForm.class, repo = EditHistoryRepo.class)
public class EditHistoryService extends PaginationService<EditHistoryModel> {
    public EditHistoryService(WebContext holder) {
        super(holder);
    }

    @Override
    public Optional<EditHistoryModel> findById(String id) {
        return getRepository().filteredOne(getFilterImpl().id( id));
    }


    public Optional<EditHistoryModel> findByEditedTypeAndId(String type, String id) {
        EditHistoryRepo repo = getRepository();
        return repo.filteredFirst(getFilterImpl().eq("editedTpe", type).and(getFilterImpl().eq("idEditedObject", id)));
    }

    public Page<EditHistoryModel> findByEditedType(String type) {
        EditHistoryRepo repo = getRepository();
        return repo.filteredData((MongoSpecification<EditHistoryModel>) getFilterImpl().eq("classEditedObject", type));

    }

    @Override
    public EditHistoryRepo getRepository() {
        return super.getRepository();
    }
}
