package systems.dennis.shared.mongo.controller;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.controller.items.AbstractAddItemController;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.mongo.service.StringIdEntity;
import systems.dennis.shared.mongo.form.DefaultForm;
@RestController
@Secured
public interface AddItemController<T extends StringIdEntity,E extends DefaultForm> extends AbstractAddItemController<T,E, String> {


    @PostMapping(value = "/add",  consumes = {"application/json", "application/json;charset=UTF-8"}, produces = {"application/json", "application/json;charset=UTF-8"})
    @ResponseBody
    @WithRole
    @Override
    default ResponseEntity<E> add(@RequestBody E form) throws ItemForAddContainsIdException {
        return AbstractAddItemController.super.add(form);
    }
}
