/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.mongo.specification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import systems.dennis.shared.mongo.exception.IncorrectSpecification;
import systems.dennis.shared.mongo.service.StringIdEntity;

public class SpecificationFieldChecker {
    private static final String DEFAULT_FIELDS = "DEFAULT_FIELDS";
    private static List<String> defaultFields = new ArrayList<String>();

    private SpecificationFieldChecker() {
    }

    public static void checkFieldExistsInClass(String field, Class<? extends StringIdEntity> o) {
        defaultFields.clear();
        if (o == null) {
            throw new IncorrectSpecification("Class should not be null on request");
        }
        defaultFields = SpecificationFieldChecker.collectAllDefaultFields(o).stream().distinct().collect(Collectors.toList());
        if (field == null) {
            throw new IncorrectSpecification("field should not be null");
        }
        if (!defaultFields.contains(field)) {
            if (field.contains(".")) {
                SpecificationFieldChecker.checkComplexField(o, field);
            } else {
                SpecificationFieldChecker.checkSimpleType(o, field);
            }
        }
    }

    private static List<String> collectAllDefaultFields(Class<? extends StringIdEntity> clazz) {
        if (clazz != StringIdEntity.class) {
            SpecificationFieldChecker.collectAllDefaultFields(clazz.getSuperclass());
        }
        Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.getName().equals(DEFAULT_FIELDS)).forEach(field -> {
            try {
                defaultFields.addAll((Collection)field.get(null));
            }
            catch (IllegalAccessException e) {
                throw new IncorrectSpecification("Class " + String.valueOf(clazz) + " does not has property " + field.getName());
            }
        });
        return defaultFields;
    }

    private static void checkComplexField(Class<? extends StringIdEntity> o, String field) {
        SpecificationFieldChecker.checkSimpleType(o, field.split("\\.")[0]);
    }

    private static void checkSimpleType(Class<? extends StringIdEntity> o, String field) {
        try {
            o.getDeclaredField(field);
        }
        catch (Exception e) {
            throw new IncorrectSpecification("Class " + o.getSimpleName() + " does not has property " + field);
        }
    }
}

