package systems.dennis.shared.mongo.repository.query_processors;

import org.springframework.data.mongodb.core.query.Criteria;
import systems.dennis.shared.repository.AbstractDataFilter;

import java.util.ArrayList;
import java.util.Collections;

public class CollectionPredicateProcessor extends AbstractClassProcessor {

    public CollectionPredicateProcessor(AbstractDataFilter<?> queryCase, Criteria root) {
        super(queryCase, root);
    }


    @Override
    public void processDefault() {

        var queryCase = getFilter();
        if (AbstractDataFilter.CONTAINS_OPERATOR.equalsIgnoreCase(queryCase.getOperator())) {
            getRoot().in(Collections.singleton(queryCase.getValue()));
        }
        if (AbstractDataFilter.NOT_CONTAINS_OPERATOR.equalsIgnoreCase(queryCase.getOperator())) {
            getRoot().nin(Collections.singleton(queryCase.getValue()));
        }
        if (AbstractDataFilter.NOT_EMPTY.equalsIgnoreCase(queryCase.getOperator())) {
            getRoot().ne(new ArrayList<>());
        }
        if (AbstractDataFilter.EMPTY.equalsIgnoreCase(queryCase.getOperator())) {
            getRoot().is(new ArrayList<>());
        }
        if (AbstractDataFilter.IN.equalsIgnoreCase(queryCase.getOperator())) {
            getRoot().in(queryCase.getValue());

        }
        if (AbstractDataFilter.NOT_IN.equalsIgnoreCase(queryCase.getOperator())) {
           getRoot().nin(queryCase.getValue());
        }
        if (AbstractDataFilter.NOT_EQUALS_OPERATOR.equalsIgnoreCase(queryCase.getOperator())) {
            getRoot().ne(queryCase.getValue());
        }

    }

    @Override
    public Object getValue(Object value) {
        return value;
    }
}
