package systems.dennis.shared.scopes.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Transient;
import lombok.Data;
import systems.dennis.shared.postgres.model.BaseEntity;

@Data
@Entity
public class AppSettingsModel extends BaseEntity {

    private String key;
    private String value;
    private String valueClassType;

    @Transient
    private Object realValue;

    @Override
    public String asValue() {
        return key + " " + value;
    }
}
