/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.scopes.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.beans.AppSettingsResolver;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.converters.SettingsValueType;
import systems.dennis.shared.exceptions.SettingKeyNotFoundException;
import systems.dennis.shared.exceptions.SettingValueTypeNotFoundException;
import systems.dennis.shared.postgres.service.PaginationService;
import systems.dennis.shared.scopes.converters.AppSettingsValueTypeIdentifier;
import systems.dennis.shared.scopes.form.AppSettingsForm;
import systems.dennis.shared.scopes.model.AppSettingsModel;
import systems.dennis.shared.scopes.repository.AppSettingsRepo;

@Service
@Primary
@DataRetrieverDescription(model=AppSettingsModel.class, form=AppSettingsForm.class, repo=AppSettingsRepo.class)
public class AppSettingsService
extends PaginationService<AppSettingsModel>
implements AppSettingsResolver {
    public static final String SPRING_PREFIX = "spring.";
    private Map<String, AppSettingsModel> settingsCache = new HashMap<String, AppSettingsModel>();
    @Autowired
    private AppSettingsValueTypeIdentifier identifier;
    @Autowired
    Environment environment;
    public static final Map<String, String> SHARED_SETTINGS_WITH_DEFAULT_VALUE = Map.ofEntries(Map.entry("pages.auth.login", "/client_login"), Map.entry("global.use_cache_translation", "true"), Map.entry("global.messages.path", "./i18n"), Map.entry("global.use_db_updater", "false"), Map.entry("global.project_update_file", "null"), Map.entry("global.basic_update_file", "db/root-sql-init/db.yml"), Map.entry("global.settings.favorite.enabled", "true"));
    private final Logger log = LoggerFactory.getLogger(AppSettingsService.class);
    @Value(value="${global.app.settings.enabled: true}")
    private Boolean isEnabled;

    public AppSettingsService(WebContext holder) {
        super(holder);
    }

    public <T> T getSetting(String settingKey) throws SettingKeyNotFoundException, SettingValueTypeNotFoundException {
        String valueType = "";
        if (!this.settingsCache.containsKey(settingKey)) {
            throw new SettingKeyNotFoundException(settingKey, "shared.settings.value.not_defined");
        }
        AppSettingsModel setting = this.settingsCache.get(settingKey);
        return (T)setting.getRealValue();
    }

    public void saveApplicationSettingsIntoDB() {
        if (this.isEnabled.booleanValue()) {
            List<AppSettingsModel> settings = this.readApplicationSettings();
            List<AppSettingsModel> newComingSettings = settings.stream().filter(x -> this.isEmpty(this.getContext().getDataFilterProvider().eq("key", (Object)x.getKey()))).collect(Collectors.toList());
            newComingSettings.forEach(arg_0 -> ((AppSettingsService)this).save(arg_0));
            settings.forEach(this::addToCache);
        }
    }

    public List<String> getEnvProperties() {
        Iterator it = ((AbstractEnvironment)this.environment).getPropertySources().iterator();
        ArrayList<String> res = new ArrayList<String>();
        while (it.hasNext()) {
            Map item;
            Object sources = ((PropertySource)it.next()).getSource();
            if (!(sources instanceof Map) || !(item = (Map)sources).containsKey("server.port")) continue;
            res.addAll(item.keySet());
        }
        return res;
    }

    private List<AppSettingsModel> readApplicationSettings() {
        List<String> keys = this.getEnvProperties();
        ArrayList<AppSettingsModel> models = new ArrayList<AppSettingsModel>();
        for (String key : keys) {
            if (key.startsWith(SPRING_PREFIX)) continue;
            models.add(this.createSettingObject(key, this.environment.getProperty(key)));
        }
        models.addAll(this.getSettingsNotContainingInAppProperties(models));
        return models;
    }

    private AppSettingsModel createSettingObject(String key, String value) {
        AppSettingsModel setting = new AppSettingsModel();
        setting.setKey(key);
        setting.setValue(value);
        setting.setValueClassType(this.identifier.identify(key, value));
        return setting;
    }

    private List<AppSettingsModel> getSettingsNotContainingInAppProperties(List<AppSettingsModel> models) {
        ArrayList<AppSettingsModel> result = new ArrayList<AppSettingsModel>();
        List appSettingKeys = models.stream().map(AppSettingsModel::getKey).collect(Collectors.toList());
        Set<String> differenceOfKeys = SHARED_SETTINGS_WITH_DEFAULT_VALUE.keySet().stream().filter(key -> !appSettingKeys.contains(key)).collect(Collectors.toSet());
        differenceOfKeys.forEach(key -> {
            AppSettingsModel setting = this.createSettingObject((String)key, SHARED_SETTINGS_WITH_DEFAULT_VALUE.get(key));
            result.add(setting);
        });
        return result;
    }

    private AppSettingsModel addToCache(AppSettingsModel setting) {
        setting.setRealValue(this.calcRealValue(setting));
        this.settingsCache.put(setting.getKey(), setting);
        return setting;
    }

    private Object calcRealValue(AppSettingsModel setting) {
        String settingValue = setting.getValue();
        String valueType = setting.getValueClassType();
        if (valueType.equalsIgnoreCase(SettingsValueType.STRING.name())) {
            return settingValue;
        }
        if (valueType.equalsIgnoreCase(SettingsValueType.PASSWORD.name())) {
            return settingValue;
        }
        if (valueType.equalsIgnoreCase(SettingsValueType.INTEGER.name())) {
            return Integer.valueOf(settingValue);
        }
        if (valueType.equalsIgnoreCase(SettingsValueType.BOOLEAN.name())) {
            return Boolean.valueOf(settingValue);
        }
        throw new SettingValueTypeNotFoundException(valueType, "shared.settings.value_type.not.found");
    }

    public void afterEdit(AppSettingsModel object, AppSettingsModel original) {
        this.addToCache(object);
    }

    public AppSettingsModel afterAdd(AppSettingsModel object) {
        return this.addToCache(object);
    }

    public AppSettingsModel afterDelete(AppSettingsModel object) {
        this.settingsCache.remove(object.getKey());
        return object;
    }

    public boolean hasSetting(String setting) {
        return this.settingsCache.containsKey(setting);
    }

    public <T> T getEnv(String key) {
        return this.getSetting(key);
    }

    public <T> T getEnv(String key, Object def) {
        try {
            return this.getEnv(key);
        }
        catch (SettingKeyNotFoundException e) {
            return (T)def;
        }
    }
}

