/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.scopes.converters;

import org.springframework.stereotype.Component;
import systems.dennis.shared.converters.SettingsValueType;
import systems.dennis.shared.converters.ValueTypeIdentifier;

@Component
public class AppSettingsValueTypeIdentifier
implements ValueTypeIdentifier<String, String> {
    public static final String KEY_PASSWORD = "password";
    public static final String KEY_TOKEN = "token";
    public static final String REGEX_NUMBER = "[1-9][0-9]+";

    public String identify(String key, String value) {
        if (this.checkInteger(value = value.trim())) {
            return SettingsValueType.INTEGER.name();
        }
        if (this.checkBoolean(value)) {
            return SettingsValueType.BOOLEAN.name();
        }
        if (this.checkPassword(key)) {
            return SettingsValueType.PASSWORD.name();
        }
        return SettingsValueType.STRING.name();
    }

    private boolean checkBoolean(String value) {
        return value.equalsIgnoreCase("false") || value.equalsIgnoreCase("true");
    }

    private boolean checkInteger(String value) {
        if (value.equals("0")) {
            return true;
        }
        return value.matches(REGEX_NUMBER);
    }

    private boolean checkPassword(String key) {
        return key.contains(KEY_TOKEN) || key.contains(KEY_PASSWORD);
    }
}

