package systems.dennis.shared.scopes.controller;

import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.config.WebConstants;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.*;
import systems.dennis.shared.postgres.controller.AddItemController;
import systems.dennis.shared.postgres.controller.DeleteItemController;
import systems.dennis.shared.postgres.controller.EditItemController;
import systems.dennis.shared.postgres.controller.ListItemController;
import systems.dennis.shared.scopes.form.AppSettingsForm;
import systems.dennis.shared.scopes.model.AppSettingsModel;
import systems.dennis.shared.scopes.service.AppSettingsService;
import systems.dennis.shared.utils.ApplicationContext;

import java.util.Map;

@RestController
@RequestMapping("/api/v2/shared/app_settings")
@WebFormsSupport(value = AppSettingsService.class)
@CrossOrigin
@Secured (roles = "ROLE_ADMIN")
public class AppSettingsController
        extends ApplicationContext

        implements
        DeleteItemController<AppSettingsModel>,
        ListItemController<AppSettingsModel, AppSettingsForm>,
        EditItemController<AppSettingsModel, AppSettingsForm>,
        AddItemController<AppSettingsModel, AppSettingsForm>
       {

    public AppSettingsController(WebContext context) {
        super(context);
    }

    @Override
    @GetMapping(WebConstants.WEB_API_LIST)
    public ResponseEntity<Page<Map<String, Object>>> get( Integer limit, Integer page) {
        return ListItemController.super.get( limit, page);
    }

    @Override
    @PutMapping( WebConstants.WEB_API_EDIT)

    public ResponseEntity<AppSettingsForm> edit(AppSettingsForm form) throws ItemForAddContainsIdException, ItemDoesNotContainsIdValueException, UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        return EditItemController.super.edit(form);
    }
    @Override
    @PutMapping(WebConstants.WEB_API_ADD)

    public ResponseEntity<AppSettingsForm> add(AppSettingsForm form) throws ItemForAddContainsIdException, ItemDoesNotContainsIdValueException, UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        return EditItemController.super.edit(form);
    }


    @Override
    @DeleteMapping ("/delete/{id}")
    public void delete(@PathVariable Long id) throws ItemNotUserException, ItemNotFoundException {
        DeleteItemController.super.delete(id);
    }


}
