package systems.dennis.shared.scopes.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Transient;
import lombok.Data;
import systems.dennis.shared.mongo.service.StringIdEntity;


@Data
@Entity
public class AppSettingsModel extends StringIdEntity {

    private String key;
    private String value;
    private String valueClassType;

    @Transient
    private Object realValue;

    @Override
    public String asValue() {
        return key + " " + value;
    }
}
