/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.config_service.cron;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.config_service.form.ConfigServiceForm;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.scopes.model.AppSettingsModel;
import systems.dennis.shared.scopes.service.AppSettingsService;
import systems.dennis.shared.servers.model.ServerConfig;
import systems.dennis.shared.servers.service.ServerConfigService;
import systems.dennis.shared.utils.ApplicationContext;

@Component
@EnableScheduling
public class RemoteConfigFetcher
extends ApplicationContext {
    private static final Logger log = LoggerFactory.getLogger(RemoteConfigFetcher.class);

    public RemoteConfigFetcher(WebContext context) {
        super(context);
    }

    @Scheduled(cron="${global.app.config.remote_update_cron.schedule: 0 0/5 * * * ?}")
    public void UpdateSettings() {
        if (!((Boolean)this.getContext().getEnv("global.app.config.remote_update_cron.enabled", (Object)false)).booleanValue()) {
            return;
        }
        Object path = (String)this.getContext().getEnv("global.app.config.remote_update_cron.path", (Object)"http://localhost:3333");
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        String retrievePath = (String)path + "api/v2/configuration/fetch/scope/" + (String)this.getContext().getEnv("app.config.remote_update_cron.scope", (Object)"sample_app");
        AppSettingsService appSettingsService = (AppSettingsService)this.getBean(AppSettingsService.class);
        ServerConfigService serverService = (ServerConfigService)this.getBean(ServerConfigService.class);
        try {
            ConfigServiceForm[] data;
            for (ConfigServiceForm item : data = (ConfigServiceForm[])new RestTemplate().exchange(retrievePath, HttpMethod.GET, null, ConfigServiceForm[].class, new Object[0]).getBody()) {
                if (item.getServerConfig() != null) {
                    this.createOrUpdateServer(item, serverService);
                    continue;
                }
                this.createOrUpdateExistingEntry(item, appSettingsService);
            }
        }
        catch (Exception e) {
            log.error("cannot_invoke_retrieve_config_service", (Throwable)e);
        }
    }

    private void createOrUpdateServer(ConfigServiceForm form, ServerConfigService service) {
        try {
            ServerConfig server = form.getServerConfigValue();
            ServerConfig existing = service.getRepository().filteredFirst(service.getFilterImpl().eq("name", (Object)server.getName()).and(service.getFilterImpl().eq("type", (Object)server.getType()))).orElse(new ServerConfig());
            existing.setActive(server.getActive());
            existing.setHost(server.getHost());
            existing.setUserName(server.getUserName());
            existing.setPassword(server.getPassword());
            existing.setName(server.getName());
            existing.setType(server.getType());
            existing.setTimeZone(server.getTimeZone());
            existing.setPort(server.getPort());
            existing.setServerParam(server.getServerParam());
            service.save((IDPresenter)existing);
        }
        catch (Exception e) {
            log.error("cannot_save_config_service_item", (Throwable)e);
        }
    }

    private void createOrUpdateExistingEntry(ConfigServiceForm item, AppSettingsService appSettingsService) {
        AppSettingsModel existing = appSettingsService.getRepository().filteredFirst(appSettingsService.getFilterImpl().eq("key", (Object)item.getProperty_name())).orElse(new AppSettingsModel());
        existing.setKey(item.getProperty_name());
        existing.setValue(item.getProperty_value());
        existing.setValueClassType(item.getValue_class_type() == null ? "text" : item.getValue_class_type());
        ((AppSettingsService)this.getBean(AppSettingsService.class)).addToCache(existing);
        try {
            appSettingsService.save((IDPresenter)existing);
        }
        catch (Exception e) {
            log.error("cannot_save_config_service_item", (Throwable)e);
        }
    }
}

