package systems.dennis.auth.validators;

import systems.dennis.shared.annotations.ValidationContent;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.pojo_form.ValidationResult;
import systems.dennis.shared.validation.ValueValidator;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.client.utils.SecurityUtils;
import systems.dennis.auth.service.ProfilePageService;

import java.util.Optional;

public class EmailExistenceValidator implements ValueValidator<Object, String> {

    @Override
    public ValidationResult validate(Object element, String value,
                                     ValidationContent content) {

        Optional<UserData> userData = content.getContext().getBean(ProfilePageService.class).findByEmail(value);

        if (userData.isPresent()) {
            try {
                UserData currentUser = content.getContext().getBean(SecurityUtils.class).get().getUserData();
                if (!currentUser.getEmail().equals(value)) {
                    return ValidationResult.fail("email.already.registered");
                }
            } catch (Exception e) {
                return ValidationResult.fail("email.already.registered");
            }
        }
        return ValidationResult.PASSED;
    }
}
