package systems.dennis.auth.service;

import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.postgres.service.PaginationService;
import systems.dennis.shared.service.AbstractPaginationService;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.form.LoginPasswordForm;
import systems.dennis.auth.repository.LoginPasswordRepo;

@Service
@DataRetrieverDescription(model = LoginPassword.class, form = LoginPasswordForm.class, repo = LoginPasswordRepo.class)
@Primary
public class UsersPageService extends PaginationService<LoginPassword> {

    public UsersPageService( WebContext context) {
        super(context);
    }




}
