package systems.dennis.auth.role_validator.entity;

import lombok.Data;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.pojo_view.list.Remote;
import systems.dennis.shared.postgres.form.DefaultForm;

import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.HIDDEN;
import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.OBJECT_SEARCH;

@Data ()
public class RolesToUserForm implements DefaultForm {

    @PojoFormElement  (type = HIDDEN)

    public Long id;
    @PojoFormElement(type = OBJECT_SEARCH)
    @PojoListViewField (type = OBJECT_SEARCH, remote = @Remote(searchName = "lp", searchField = "login", fetcher = "api/v2/lp"))
    private LoginPassword password;


    private UserRole role;
}
