package systems.dennis.auth.role_validator.entity;

import jakarta.persistence.Entity;
import jakarta.persistence.ManyToOne;
import lombok.Data;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.service.LoginPasswordService;
import systems.dennis.shared.postgres.model.LongAssignableEntity;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Data
@Entity (name = "role_to_user")
public class RolesToUser extends LongAssignableEntity {

    @ManyToOne
    @DataTransformer(additionalClass = LoginPasswordService.class, transFormWith = IdToObjectTransformer.class)
    private LoginPassword password;

    @ManyToOne
    @DataTransformer(additionalClass = UserRole.class, transFormWith = IdToObjectTransformer.class)
    private UserRole role;

    @Override
    public String asValue() {
        return role.getRole() + " " + password.getLogin();
    }
}
