package systems.dennis.auth.repository;

import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import systems.dennis.auth.entity.VirtualLoginPassword;
import systems.dennis.shared.postgres.repository.PaginationRepository;

import java.util.Optional;

@Repository
public interface VirtualLoginPasswordRepo extends PaginationRepository<VirtualLoginPassword> {
    @Query(value = "select * from virtual_login_password where name= :login and password = :password", nativeQuery = true)
    Optional<VirtualLoginPassword> login(@Param("login") String user, @Param("password") String password);
}
