package systems.dennis.auth.model;

import jakarta.persistence.Entity;
import lombok.Data;
import systems.dennis.shared.annotations.FormTransient;
import systems.dennis.shared.annotations.entity.Created;
import systems.dennis.shared.postgres.model.BaseEntity;

import java.util.Date;

@Entity @Data
public class PhoneAuthorizationCodes extends BaseEntity {

    public static final String AUTHORIZATION = "request_authorization";
    public static final String REGISTRATION = "request_registration";

    private String code;
    private String login;
    private Date expiryDate;

    private Date updated;

    private String type;

    @Created
    @FormTransient
    private String created;

    @Override
    public String asValue() {
        return "";
    }
}
