package systems.dennis.auth.controller;

import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.auth.entity.VirtualLoginPassword;
import systems.dennis.auth.form.VirtualLoginPasswordForm;
import systems.dennis.auth.service.VirtualLoginPasswordService;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.AbstractSelfItemsListController;
import systems.dennis.shared.postgres.controller.DeleteItemController;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping("/api/v2/auth/virtual")
@CrossOrigin
@WebFormsSupport(value = VirtualLoginPasswordService.class)
public class VirtualLoginPasswordController extends ApplicationContext implements DeleteItemController<VirtualLoginPassword>, AbstractSelfItemsListController<VirtualLoginPassword, VirtualLoginPasswordForm, Long> {

    public VirtualLoginPasswordController(WebContext context) {
        super(context);
    }

    @PostMapping("/create")
    @WithRole("ROLE_ADMIN")
    public VirtualLoginPassword create() {
        return getService().create();
    }

    @Override
    public VirtualLoginPasswordService getService() {
        return getContext().getBean(VirtualLoginPasswordService.class);
    }
}
