package systems.dennis.auth.controller;


import lombok.SneakyThrows;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import systems.dennis.auth.role_validator.entity.UserTokenDTO;
import systems.dennis.auth.client.required.TokenProviderClient;
import systems.dennis.auth.client.required.TokenValidator;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;

@RestController
@RequestMapping("api/v2/auth")
@CrossOrigin(origins = "*")
public class TokenProviderController {

    private final TokenProviderClient tokenProvider;
    private TokenValidator validator;
    private HttpServletRequest request;


    public TokenProviderController(
            TokenProviderClient tokenProvider, TokenValidator validator, HttpServletRequest request) {
        this.tokenProvider = tokenProvider;
        this.validator = validator;
        this.request = request;
    }

    @GetMapping(value = "/validate/{token}")
    @SneakyThrows
    public ResponseEntity<UserTokenDTO> validateToken(@PathVariable("token") String token) {
        UserTokenDTO dto = new UserTokenDTO();
        dto.setToken(token);
        return ResponseEntity.ok(tokenProvider.validateToken(dto));
    }

    @GetMapping(value = "/hasAnyRoleFrom")
    @SneakyThrows
    public ResponseEntity<List<String>> getValidRoles(@RequestParam("roles") List<String> roles) {
        List<String> validGroups = validator.getValidGroups(roles);
        return ResponseEntity.ok(validGroups);
    }
}
