package systems.dennis.auth.controller;


import org.springframework.web.bind.annotation.*;
import systems.dennis.auth.form.RoleForm;
import systems.dennis.auth.role_validator.entity.UserRole;
import systems.dennis.auth.service.RoleServiceImpl;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.postgres.controller.AddItemController;
import systems.dennis.shared.postgres.controller.DeleteItemController;
import systems.dennis.shared.postgres.controller.EditItemController;
import systems.dennis.shared.postgres.controller.ListItemController;
import systems.dennis.shared.utils.ApplicationContext;


/**
 * Provides Role adding, editing, deleting and assigning
 */
@RestController
@RequestMapping("api/v2/auth/roles")
@Secured (roles = "ROLE_ADMIN")
@CrossOrigin
@WebFormsSupport(RoleServiceImpl.class)
public class RoleController extends ApplicationContext implements Serviceable<UserRole, Long>,
        DeleteItemController<UserRole>,
        AddItemController<UserRole, RoleForm>,
        EditItemController<UserRole, RoleForm>,
        ListItemController<UserRole, RoleForm> {
    static  {
        SearchEntityApi.registerSearch("role", new SearcherInfo("role", RoleServiceImpl.class));
    }

    public RoleController(WebContext context) {
        super(context );
    }


    @DeleteMapping("/deassign/{roleId}/{login}")
    public Boolean deAssign(@PathVariable Long roleId, @PathVariable String login ) {
        RoleServiceImpl service =  getService();
        return service.deAssignRole(roleId, login );
    }

    @PostMapping("/assign/{roleId}/{login}")
    public Boolean assign(@PathVariable Long roleId, @PathVariable String login) {
        RoleServiceImpl service =  getService();
        return service.assignRole(roleId, login);
    }


}
