package systems.dennis.auth.controller;

import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.auth.entity.LoginHistory;
import systems.dennis.auth.form.LoginHistoryForm;
import systems.dennis.auth.service.LoginHistoryService;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.controller.items.AbstractSelfItemsListController;
import systems.dennis.shared.utils.ApplicationContext;

import static systems.dennis.auth.role_validator.entity.UserRole.ROLE_ADMIN;

@RestController
@RequestMapping("/api/v2/auth/login_history")
@WebFormsSupport(value = LoginHistoryService.class)
@CrossOrigin
@Secured(roles = ROLE_ADMIN)
public class LoginHistoryController extends ApplicationContext
        implements AbstractSelfItemsListController<LoginHistory, LoginHistoryForm, Long> {

    static {
        SearchEntityApi.registerSearch("login",  new SearcherInfo("login", LoginHistoryService.class));
    }

    public LoginHistoryController(WebContext context) {
        super(context);
    }
}
