package systems.dennis.auth.controller;

import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.form.LoginPasswordForm;
import systems.dennis.auth.service.LoginPasswordService;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.postgres.controller.ListItemController;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping("/api/v2/lp")
@WebFormsSupport(LoginPasswordService.class)
@CrossOrigin
public class LPController extends ApplicationContext implements ListItemController<LoginPassword, LoginPasswordForm> {
    static {
        SearchEntityApi.registerSearch("lp", new SearcherInfo("login", LoginPasswordService.class));

    }

    public LPController(WebContext context) {
        super(context);
    }

}
