package systems.dennis.auth.controller;

import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.auth.service.DataCleanupService;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping ("/api/v2/auth/data_cleanup")
@CrossOrigin
public class DataCleanupController extends ApplicationContext {

    public DataCleanupController(WebContext context) {
        super(context);
    }

    @WithRole("ROLE_SYNC")
    @DeleteMapping("/clean/{name}")
    public Boolean findByScope(@PathVariable("name") String scopeName) {
        return getBean(DataCleanupService.class).cleanupData(scopeName);
    }
}
