package systems.dennis.auth.validators;

import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.form.UserInScopeForm;
import systems.dennis.auth.service.AuthScopeService;
import systems.dennis.auth.service.ProfilePageService;
import systems.dennis.auth.service.UserInScopeService;
import systems.dennis.shared.annotations.ValidationContent;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.pojo_form.ValidationResult;
import systems.dennis.shared.scopes.model.ScopeModel;
import systems.dennis.shared.validation.ValueValidator;

public class UniqueUserScopeValidator implements ValueValidator<UserInScopeForm, Long> {

    @Override
    public ValidationResult validate(UserInScopeForm element, Long value, ValidationContent content) {
        UserData user = content.getContext().getBean(ProfilePageService.class).findByIdOrThrow(element.getUser());
        ScopeModel scope = content.getContext().getBean(AuthScopeService.class).findByIdOrThrow(element.getScope());

        boolean isDuplicate = content.getContext().getBean(UserInScopeService.class).isRelationExist(user, scope);

        if (isDuplicate) {
            return ValidationResult.fail(content.getContext().getScoped("duplicate.relationship"));
        }

        return ValidationResult.PASSED;
    }
}
