package systems.dennis.auth.validators;

import systems.dennis.auth.form.RoleForm;
import systems.dennis.auth.service.AuthScopeService;
import systems.dennis.auth.service.RoleServiceImpl;
import systems.dennis.shared.annotations.ValidationContent;
import systems.dennis.shared.config.WebContext;

import systems.dennis.shared.pojo_form.ValidationResult;
import systems.dennis.shared.scopes.model.ScopeModel;
import systems.dennis.shared.validation.ValueValidator;

public class UniqueRoleScopeValidator implements ValueValidator<RoleForm, String> {

    @Override
    public ValidationResult validate(RoleForm element, String value, ValidationContent content) {
        ScopeModel scope = content.getContext().getBean(AuthScopeService.class).findByIdOrThrow(element.getScope());

        boolean isDuplicate = content.getContext().getBean(RoleServiceImpl.class).isRelationExist(element.getRole(), scope);

        if (isDuplicate) {
            return ValidationResult.fail(content.getContext().getScoped("duplicate.relationship"));
        }

        return ValidationResult.PASSED;
    }
}
