package systems.dennis.auth.validators;

import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.entity.UserInScopeModel;
import systems.dennis.auth.form.RoleToUserForm;
import systems.dennis.auth.role_validator.entity.RolesToUser;
import systems.dennis.auth.role_validator.entity.UserRole;
import systems.dennis.auth.service.LoginPasswordService;
import systems.dennis.auth.service.ProfilePageService;
import systems.dennis.auth.service.RoleServiceImpl;
import systems.dennis.auth.service.RoleToUserService;
import systems.dennis.auth.service.UserInScopeService;
import systems.dennis.shared.annotations.ValidationContent;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.pojo_form.ValidationResult;
import systems.dennis.shared.repository.AbstractDataFilter;
import systems.dennis.shared.validation.ValueValidator;

public class RoleToUserValidator implements ValueValidator<RoleToUserForm, Long> {

    @Override
    public ValidationResult validate(RoleToUserForm element, Long value, ValidationContent content) {
        UserRole role = content.getContext().getBean(RoleServiceImpl.class).findByIdOrThrow(element.getRole());
        LoginPassword password = content.getContext().getBean(LoginPasswordService.class).findByIdOrThrow(element.getPassword());
        UserData user = content.getContext().getBean(ProfilePageService.class).findByEmail(password.getLogin())
                .orElseThrow(() -> new ItemNotFoundException(password.getLogin()));

        AbstractDataFilter<UserInScopeModel> filter = content.getContext().getBean(UserInScopeService.class).getFilterImpl().eq("user", user)
                .and(content.getContext().getBean(UserInScopeService.class).getFilterImpl().eq("scope", role.getScope()))
                .and(content.getContext().getBean(UserInScopeService.class).getNotDeletedQuery());

        if (content.getContext().getBean(UserInScopeService.class).count(filter) > 0) {
            AbstractDataFilter<RolesToUser> rolesToUserFilter = content.getContext().getBean(RoleToUserService.class).getFilterImpl().eq("password", password)
                    .and(content.getContext().getBean(RoleToUserService.class).getFilterImpl().eq("role", role))
                    .and(content.getContext().getBean(RoleToUserService.class).getNotDeletedQuery());

            if (content.getContext().getBean(RoleToUserService.class).count(rolesToUserFilter) > 0) {
                ValidationResult.fail(content.getContext().getScoped("role.already.assign"));
            }

            return ValidationResult.PASSED;
        }

        return ValidationResult.fail(content.getContext().getScoped("User.not.belong.to.scope"));
    }
}
