package systems.dennis.auth.role_validator.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.ManyToOne;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import systems.dennis.auth.service.AuthScopeService;
import systems.dennis.shared.postgres.model.LongAssignableEntity;
import systems.dennis.shared.scopes.model.ScopeModel;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Data
@Entity (name = "user_role")
@AllArgsConstructor
@NoArgsConstructor
public class UserRole extends LongAssignableEntity {

    public static final String ROLE_USER = "ROLE_USER";
    public static final String ROLE_ADMIN = "ROLE_ADMIN";
    public static final String ROLE_SIGNED = "ROLE_ANY";
    private String role;

    @Column(name = "autoApply")
    private Boolean addToEveryUser;
    public Boolean autoApplyOnVirtualUser;

    @ManyToOne
    @DataTransformer(additionalClass = AuthScopeService.class, transFormWith = IdToObjectTransformer.class)
    private ScopeModel scope;


    @Override
    public String asValue() {

        var res =  role  ;
        if (scope == null){
            role += " undefined_scope";
        } else {
            role += " " + scope.asValue();
        }
        return  res;
    }
}
