package systems.dennis.auth.repository;

import org.springframework.stereotype.Repository;
import systems.dennis.auth.role_validator.entity.UserRole;
import systems.dennis.shared.postgres.repository.PaginationRepository;

import java.util.List;
import java.util.Optional;

@Repository
public interface UserRoleRepo extends PaginationRepository<UserRole> {
    Optional<UserRole> getByUserDataIdAndRole(Long id, String roleId);
    List<UserRole> getByRole(String id);
    List<UserRole> getByUserDataId(Long id);
    void deleteByUserDataId(Long userId);
    void deleteByRole(String roleId);

    boolean existsByRole(String role);

    Optional<UserRole> findFirstByRoleAndId(String value, Long id);
}
