package systems.dennis.auth.repository;

import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.role_validator.entity.RolesToUser;
import systems.dennis.auth.role_validator.entity.UserRole;
import systems.dennis.shared.postgres.repository.PaginationRepository;

import java.util.Optional;

public interface RolesToUserRepo extends PaginationRepository<RolesToUser> {

    boolean existsByRoleAndPassword(UserRole role, LoginPassword password);

    Optional<RolesToUser> findByPasswordAndRole(LoginPassword user, UserRole roleId);
}
