package systems.dennis.auth.model;

import jakarta.persistence.Entity;
import jakarta.persistence.ManyToOne;
import lombok.Data;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.service.AuthScopeService;
import systems.dennis.auth.service.ProfilePageService;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.pojo_view.list.Remote;
import systems.dennis.shared.postgres.model.LongAssignableEntity;
import systems.dennis.shared.scopes.model.ScopeModel;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;
import systems.dennis.shared.utils.bean_copier.DateToUTCConverter;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

import java.util.Date;

import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.DATE;

@Data
@Entity
public class InvitationModel extends LongAssignableEntity {

    private String name;

    private String email;

    @ManyToOne
    @ObjectByIdPresentation
    @DataTransformer(transFormWith = IdToObjectTransformer.class, additionalClass = ProfilePageService.class)
    private UserData inviter;

    private Boolean accepted;

    @ManyToOne
    @ObjectByIdPresentation
    @DataTransformer(additionalClass = AuthScopeService.class, transFormWith = IdToObjectTransformer.class)
    private ScopeModel scope;

    @PojoFormElement(type = DATE)
    @PojoListViewField(searchable = true, type = DATE, remote = @Remote(searchType = DATE))
    @DataTransformer(transFormWith  = DateToUTCConverter.class)
    private Date date;

    @PojoFormElement(type = DATE)
    @PojoListViewField(searchable = true, type = DATE, remote = @Remote(searchType = DATE))
    @DataTransformer(transFormWith  = DateToUTCConverter.class)
    private Date dateDue;

    @Override
    public String asValue() {
        return inviter.getName();
    }
}
