package systems.dennis.auth.form;

import lombok.Data;
import systems.dennis.auth.service.AuthScopeService;
import systems.dennis.auth.service.ProfilePageService;
import systems.dennis.auth.validators.UniqueUserScopeValidator;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.annotations.Validation;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.DEFAULT_TYPES;
import systems.dennis.shared.pojo_view.UIAction;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.pojo_view.list.Remote;
import systems.dennis.shared.postgres.form.DefaultForm;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.HIDDEN;

@Data
@PojoListView(actions = {"download", "new", "settings"})
public class UserInScopeForm implements DefaultForm {

    @PojoFormElement(type = HIDDEN)
    private Long id;

    @ObjectByIdPresentation
    @Validation(UniqueUserScopeValidator.class)
    @DataTransformer(transFormWith = IdToObjectTransformer.class, additionalClass = ProfilePageService.class)
    @PojoFormElement(type = DEFAULT_TYPES.OBJECT_SEARCH,
            remote = @Remote(fetcher = "auth/profile", searchType = DEFAULT_TYPES.OBJECT_SEARCH, searchField = "login", searchName = "profile"))
    @PojoListViewField(type = DEFAULT_TYPES.OBJECT_SEARCH, searchable = true,
            remote = @Remote(fetcher = "auth/profile", searchType = DEFAULT_TYPES.OBJECT_SEARCH, searchField = "login", searchName = "profile"))
    private Long user;

    @ObjectByIdPresentation
    @DataTransformer(transFormWith = IdToObjectTransformer.class, additionalClass = AuthScopeService.class)
    @PojoFormElement(type = DEFAULT_TYPES.OBJECT_SEARCH,
            remote = @Remote(fetcher = "auth/scope", searchType = DEFAULT_TYPES.OBJECT_SEARCH, searchField = "name", searchName = "scope"))
    @PojoListViewField(type = DEFAULT_TYPES.OBJECT_SEARCH, searchable = true,
            remote = @Remote(fetcher = "auth/scope", searchType = DEFAULT_TYPES.OBJECT_SEARCH, searchField = "name", searchName = "scope"))
    private Long scope;

    @PojoListViewField(actions = {@UIAction(component = "edit"), @UIAction(component = "delete", allowOnMultipleRows = true)}, visible = false)
    @PojoFormElement(available = false)
    private Integer action;
}
