package systems.dennis.auth.form;

import lombok.Data;
import systems.dennis.auth.service.LoginPasswordService;
import systems.dennis.auth.service.RoleServiceImpl;
import systems.dennis.auth.validators.RoleToUserValidator;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.annotations.Validation;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.DEFAULT_TYPES;
import systems.dennis.shared.pojo_view.UIAction;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.pojo_view.list.Remote;
import systems.dennis.shared.postgres.form.DefaultForm;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Data
@PojoListView (actions = {"download", "new", "settings"})
public class RoleToUserForm  implements DefaultForm {

    private Long id;

    @ObjectByIdPresentation
    @DataTransformer(additionalClass = LoginPasswordService.class, transFormWith = IdToObjectTransformer.class)
    @PojoFormElement (type = DEFAULT_TYPES.OBJECT_SEARCH, remote = @Remote(searchField = "login", searchName = "lp", fetcher ="lp", searchType = DEFAULT_TYPES.OBJECT_SEARCH))
    @PojoListViewField (searchable = true, type = DEFAULT_TYPES.OBJECT_SEARCH, remote = @Remote(searchField = "login", searchName = "lp", fetcher ="lp", searchType = DEFAULT_TYPES.OBJECT_SEARCH))

    private Long password;

    @ObjectByIdPresentation
    @DataTransformer(transFormWith = IdToObjectTransformer.class, additionalClass = RoleServiceImpl.class)
    @PojoListViewField( type =  DEFAULT_TYPES.OBJECT_SEARCH, sortable = true, searchable = true, remote =  @Remote(searchField = "role", searchName = "role", fetcher ="auth/roles", searchType = DEFAULT_TYPES.OBJECT_SEARCH))
    @PojoFormElement (type =  DEFAULT_TYPES.OBJECT_SEARCH,  remote = @Remote(searchField = "role", searchName = "role", fetcher ="auth/roles", searchType = DEFAULT_TYPES.OBJECT_SEARCH))
    @Validation(RoleToUserValidator.class)
    private Long role;

    @PojoListViewField (actions = {@UIAction(component = "edit"), @UIAction(component = "delete", allowOnMultipleRows = true)})
    private Integer actions;
}
