package systems.dennis.auth.form;

import lombok.Data;
import systems.dennis.auth.role_validator.entity.UserRole;
import systems.dennis.auth.service.AuthScopeService;
import systems.dennis.auth.validators.UniqueRoleScopeValidator;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.annotations.Validation;
import systems.dennis.shared.pojo_form.Checkable;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.DEFAULT_TYPES;
import systems.dennis.shared.pojo_view.UIAction;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.pojo_view.list.Remote;
import systems.dennis.shared.postgres.form.DefaultForm;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;
import systems.dennis.shared.validation.ValueNotEmptyValidator;

import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.CHECKBOX;
import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.HIDDEN;

@Data
@PojoListView(showId = true, enableSearching = true, actions = {"download",  "new", "settings"})
public class RoleForm implements DefaultForm {
    public static final String ROLE_ADMIN = UserRole.ROLE_ADMIN;
    public static final String ADMIN = "admin";
    @PojoFormElement(type = HIDDEN)

    private Long id;

    @Validation({ValueNotEmptyValidator.class, UniqueRoleScopeValidator.class })
    @PojoFormElement(required = true)
    @PojoListViewField(searchable = true)
    private String role;

    @PojoListViewField(searchable = true, remote = @Remote( searchType = CHECKBOX))
    @PojoFormElement(type = CHECKBOX, checked = @Checkable(isCheckElement = true, checked = true))
    private Boolean autoApply;


    @PojoFormElement(type = CHECKBOX, checked = @Checkable(isCheckElement = true, checked = true))
    @PojoListViewField(visible = false, searchable = true, remote = @Remote(searchType = CHECKBOX))
    private Boolean addToEveryUser;

    @PojoListViewField(searchable = true, remote = @Remote(searchType = CHECKBOX))
    @PojoFormElement(type = CHECKBOX, checked = @Checkable(isCheckElement = true, checked = true))
    public Boolean autoApplyOnVirtualUser;

    @ObjectByIdPresentation
    @DataTransformer(transFormWith = IdToObjectTransformer.class, additionalClass = AuthScopeService.class)
    @PojoFormElement(type = DEFAULT_TYPES.OBJECT_SEARCH,
            remote = @Remote(fetcher = "auth/scope", searchType = DEFAULT_TYPES.OBJECT_SEARCH, searchField = "name", searchName = "scope"))
    @PojoListViewField(type = DEFAULT_TYPES.OBJECT_SEARCH, searchable = true,
            remote = @Remote(fetcher = "auth/scope", searchType = DEFAULT_TYPES.OBJECT_SEARCH, searchField = "name", searchName = "scope"))
    private Long scope;

    @PojoFormElement(visible = false, required = false)
    @PojoListViewField(searchable = false, sortable = false, showContent = false, actions = {
           @UIAction(component = "edit" ), @UIAction(component = "delete", allowOnMultipleRows = true)
    })
    private Integer action;

    @Override
    public String asValue() {

        var res =  role  ;
        if (scope == null){
            res += " undefined_scope";
        } else {
            res += " " + scope;
        }
        return  res;
    }
}
