package systems.dennis.auth.form;

import lombok.Data;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.pojo_view.list.Remote;
import systems.dennis.shared.postgres.form.DefaultForm;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;

import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.DATE;
import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.HIDDEN;

@Data
@PojoListView(actions = {"download", "new", "settings"})
public class LoginHistoryForm implements DefaultForm {

    @PojoFormElement(type = HIDDEN)
    private Long id;

    @PojoFormElement(type = DATE, available = false)
    @PojoListViewField(searchable = true, type = DATE, remote = @Remote(searchType = DATE))
    @DataTransformer(transFormWith = DateAndStringConverter.class, params = "HH:mm:ss dd.MM.yyyy")
    private String loginTime;

    @PojoFormElement(required = true)
    @PojoListViewField(searchable = true)
    private String authorizationType;

    @PojoFormElement(required = true)
    @PojoListViewField(searchable = true)
    private String login;

    @Override
    public String asValue() {
        return login;
    }
}
