package systems.dennis.auth.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import lombok.Data;
import systems.dennis.shared.postgres.model.LongAssignableEntity;

@Entity
@Data
public class Subscription extends LongAssignableEntity {
    private String name;
    @Column(columnDefinition = "text")
    private String description;
    private Boolean active;
    private Long price;
    private Boolean allowMultiplePurchases;

    private Long durationInDays = -1L;

    @Override
    public String asValue() {
        return name;
    }
}
