package systems.dennis.auth.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import lombok.Data;
import org.hibernate.annotations.CreationTimestamp;
import systems.dennis.shared.postgres.model.LongAssignableEntity;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;

import java.util.Date;

@Entity
@Data
public class LoginHistory extends LongAssignableEntity {


    @CreationTimestamp
    @DataTransformer(transFormWith = DateAndStringConverter.class, params = "HH:mm:ss dd.MM.yyyy")
    private Date loginTime = new Date();

    @Column(name = "token", columnDefinition = "TEXT")
    private String token;

    private String authorizationType;

    String login;

    @Override
    public String asValue() {
        return login;
    }


}
