package systems.dennis.auth.cron;

import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import systems.dennis.auth.model.TempAccount;
import systems.dennis.auth.repository.TempAccountRepo;
import systems.dennis.auth.service.TempAccountService;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.utils.ApplicationContext;

@Component
@Slf4j
public class Cron extends ApplicationContext {

    public Cron(WebContext context) {
        super(context);
    }

    @Scheduled(cron = "0 0 6 * * *")
    public void cleanTempAccounts() {

        boolean hasNextPage = true;
        int pageLimit = getPageLimit();
        TempAccountRepo repo = getBean(TempAccountRepo.class);

        while (hasNextPage) {
            Page<TempAccount> expiredAccounts = getBean(TempAccountService.class).getExpiredAccounts(pageLimit, 0);
            repo.deleteAll(expiredAccounts.getContent());
            hasNextPage = expiredAccounts.getTotalPages() > 0;
        }
    }

    private int getPageLimit() {
        return getContext().getEnv("page.limit", 100);
    }
}
