package systems.dennis.auth.client.entity;

import jakarta.persistence.Entity;
import jakarta.persistence.Transient;
import lombok.Data;
import lombok.ToString;
import systems.dennis.shared.annotations.FormTransient;
import systems.dennis.shared.postgres.model.BaseEntity;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;

import java.util.Date;
import java.util.List;

@Entity (name = "appuser")
@Data
@ToString
public class UserData extends BaseEntity {


    public static final  String USER_ID_FIELD = "userDataId";

    private String login;
    private String email;
    private String name;
    private String phone;
    private String address;

    @FormTransient
    @DataTransformer(transFormWith = DateAndStringConverter.class, params = "HH:mm:ss dd.MM.yyyy")
    private Date lastUpdate = new Date();
    private String imagePath;
    private String preferredLanguage = "en";

    private Boolean blocked = Boolean.FALSE;
    private String telegramName;

    @Transient
    private List<String> purchases;

    @FormTransient
    private Boolean verified;

    public UserData(){}

    public UserData(String login){
        this.login = login;
    }

    @Override
    public String asValue() {
        return email;
    }
}
