package systems.dennis.auth.client;


import org.springframework.stereotype.Service;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.utils.ApplicationContext;


@Service
public class TwillioClient extends ApplicationContext {

    public TwillioClient(WebContext context) {
        super(context);
    }

    public void send(String text, String phoneNumber){
        System.out.println(text  + " "  + phoneNumber);
    }

    private String getId() {
        return getContext().getEnv("twillio.id", null);
    }

    private String getMsid() {
        return getContext().getEnv("twillio.msid", null);
    }

    private String getPassword() {
        return getContext().getEnv("twillio.token", null);
    }
}
