package systems.dennis.auth.validators;

import systems.dennis.auth.client.entity.UserDataForm;
import systems.dennis.auth.role_validator.entity.UserTokenDTO;
import systems.dennis.shared.annotations.security.selfchecker.AbstractSelfChecker;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.AccessDeniedException;
import systems.dennis.shared.utils.security.AbstractAuthorizationProvider;

public class UserDataChecker implements AbstractSelfChecker<UserDataForm> {

    @Override
    public void check(AbstractAuthorizationProvider dto, UserDataForm object, WebContext.LocalWebContext context) {
        if (object == null) return;
        if (! (dto instanceof UserTokenDTO)){
            throw new AccessDeniedException("User has not access to object ");
        }

        final UserTokenDTO tokenDTO = (UserTokenDTO) dto;

        if (!tokenDTO.getUserData().getLogin().equals(object.getLogin()) ){
            throw new AccessDeniedException("User has not access to object ");
        }
    }
}
