package systems.dennis.auth.util;

import lombok.SneakyThrows;
import org.springframework.stereotype.Service;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.client.TwillioClient;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.mail.MailSender;
import systems.dennis.auth.repository.LoginPasswordRepo;
import systems.dennis.auth.role_validator.entity.UserRole;
import systems.dennis.auth.service.RoleToUserService;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.AccessDeniedException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.mail.EmailSender;
import systems.dennis.shared.scopes.model.ScopeModel;
import systems.dennis.shared.utils.ApplicationContext;

import java.security.MessageDigest;
import java.util.*;


@Service
public class PasswordService extends ApplicationContext {
    private final LoginPasswordRepo loginPasswordRepo;
    private final RoleToUserService roleToUserService;
    private final EmailSender emailSender;
    private final TwillioClient twillioClient;

    public PasswordService(WebContext context, LoginPasswordRepo loginPasswordRepo, RoleToUserService roleToUserService, EmailSender emailSender, TwillioClient twillioClient) {
        super(context);
        this.loginPasswordRepo = loginPasswordRepo;
        this.roleToUserService = roleToUserService;
        this.emailSender = emailSender;

        this.twillioClient = twillioClient;
    }

    public static void main(String[] args) {
        System.out.println(tpw("admin"));
    }

    @SneakyThrows
    public static String tpw(String password) {

        if (password == null) {
            throw new IllegalArgumentException("User's password is not present to login");
        }

        MessageDigest md = MessageDigest.getInstance("MD5");


//        if (salt != null) {
        md.update("usb".getBytes());
//        }
        md.update(password.getBytes());

        byte[] byteData = md.digest();

        StringBuffer sb = new StringBuffer();
        for (byte byteDatum : byteData) {
            sb.append(Integer.toString((byteDatum & 0xff) + 0x100, 16)
                    .substring(1));
        }
        return sb.toString();
    }


    @SneakyThrows
    public String toPassword(String password) {

        if (password == null) {
            throw new IllegalArgumentException("User's password is not present to login");
        }

        MessageDigest md = MessageDigest.getInstance("MD5");


        if (getSalt() != null) {
            md.update(getSalt().getBytes());
        }
        md.update(password.getBytes());

        byte[] byteData = md.digest();

        StringBuffer sb = new StringBuffer();
        for (byte byteDatum : byteData) {
            sb.append(Integer.toString((byteDatum & 0xff) + 0x100, 16)
                    .substring(1));
        }
        return sb.toString();
    }

    public LoginPassword login(LoginPassword password) throws AccessDeniedException {
        return loginPasswordRepo.login(password.getLogin(), toPassword(password.getPassword())).orElseThrow(() -> new AccessDeniedException("Not user / password combination found"));
    }

    public String generateRandomPassword(int len) {
        return generate(getPasswordChars(), len);
    }

    public static String generateRandomKey(int len, String chars) {
        return generate(chars, len);
    }

    private static String generate(String chars, int len) {
        Random rnd = new Random();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; i++)
            sb.append(chars.charAt(rnd.nextInt(chars.length())));
        return sb.toString();
    }

    public List<UserRole> getRoles(LoginPassword password, ScopeModel scope) {
        return roleToUserService.findByOwner(password, scope);
    }

    public String reset(UserData dta) throws ItemNotFoundException {

        var user = loginPasswordRepo.findByLogin(dta.getLogin()).orElseThrow(() -> ItemNotFoundException.fromId(dta.getLogin()));

        var randomPswrd = UUID.randomUUID().toString().substring(0, 8);

        user.setPassword(toPassword(randomPswrd));

        loginPasswordRepo.save(user);

//        if (dta.getPhone() != null) {
//            twillioClient.send("New password: " + randomPswrd, dta.getPhone());
//            return "restored_by_phone";
//        } else {
        generateAndSendResetMessage(dta, randomPswrd);
        return "restored_by_email";
//        }
    }

    private void generateAndSendResetMessage(UserData userData, String password) {
        String path = userData.getPreferredLanguage() + "/reset_password.html";

        Map<String, String> templateParameters = new HashMap<>();
        templateParameters.put("password", password);

        String content = getBean(MailSender.class).processHtmlTemplate(path, templateParameters);
        String title = getContext().getMessageTranslation("email.reset_password.title", userData.getPreferredLanguage());

        getBean(MailSender.class).sendMail(Collections.singletonList(userData.getEmail()), content, title);
    }

    public String generateRandomUsername() {
        return generate(getUserNameChars(), 10);
    }

    private String getPasswordChars() {
        return getContext().getEnv("global.auth.password.chars", "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!@#$%&+_&:-(*)'[{}]/\\\\}");
    }

    private String getUserNameChars() {
        return getContext().getEnv("global.auth.username.chars", "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghi");
    }

    private String getSalt() {
        return getContext().getEnv("global.auth.salt");
    }
}
