package systems.dennis.auth.service;

import org.springframework.stereotype.Service;
import systems.dennis.auth.entity.ActiveToken;
import systems.dennis.auth.repository.ActiveTokensRepo;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.DeleteStrategy;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.postgres.service.PaginationService;

import static systems.dennis.shared.annotations.DeleteStrategy.DELETE_STRATEGY_PROPERTY;

@Service
@DataRetrieverDescription(model = ActiveToken.class, form = ActiveToken.class, repo = ActiveTokensRepo.class)
@DeleteStrategy(value = DELETE_STRATEGY_PROPERTY)
public class ActiveTokenService extends PaginationService<ActiveToken> {
    public ActiveTokenService(WebContext holder) {
        super(holder);
    }
}
