package systems.dennis.auth.role_validator.entity;

import jakarta.persistence.Transient;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.exception.TokenExpiredException;
import systems.dennis.shared.config.OnNull;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.utils.OrEmpty;
import systems.dennis.shared.utils.security.AbstractAuthorizationProvider;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;

import static systems.dennis.shared.utils.OrAnd.isNullOr;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder(toBuilder = true)
public class UserTokenDTO implements AbstractAuthorizationProvider, Serializable {

    private UserData userData;

    private static final  UserData NULL = new UserData();

    private String token;

    private Long due;

    private String scope;

    public void setDue(Date due) {
        this.due = due.getTime();
    }

    private List<String> roleList;

    public void setRoleList(List<LinkedHashMap<String, Object>> values){
        if (roleList == null && values != null){
            roleList = new ArrayList<>(values.size());

        }
        if (values == null) return;
        for (LinkedHashMap<String, Object> string : values) {
            roleList.add(String.valueOf(string.getOrDefault("role", 1L)));
        }
    }

    @Transient
    public void setRoleListFromGD(List<String> values){
        if (roleList == null){
            roleList = new ArrayList<>(values.size());
        }

        for (String string : values) {
            roleList.add(string);
        }

    }

    public boolean validate(WebContext.LocalWebContext context) throws TokenExpiredException {
        if ( getDue() == null || getDue() < new Date().getTime()){
            throw new TokenExpiredException(token);
        }
        return true;
    }


    public void setRoles(List<String> roles) {
        this.roleList = roles;
    }

    @Override
    public String getLogin() {
        return userData.getLogin();
    }

    @Override
    public String getPassword() {
        return "HIDDEN";
    }

    public Long getUserId() {
        return OrEmpty.valueOrDef(getUserData(), NULL).getId();
    }
}