package systems.dennis.auth.repository;

import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.shared.postgres.repository.PaginationRepository;

import java.util.Optional;

@Repository
public interface LoginPasswordRepo extends PaginationRepository<LoginPassword> {

    @Query(value = "select * from login_password where login= :login and password = :password", nativeQuery = true)
    Optional<LoginPassword> login(@Param("login") String user, @Param("password") String password);

    boolean existsByLogin(String login);


    Optional<LoginPassword> findByLogin(String userLogin);
}
