package systems.dennis.auth.repository;

import systems.dennis.auth.entity.ActiveToken;
import systems.dennis.shared.postgres.repository.PaginationRepository;
import systems.dennis.shared.repository.AbstractRepository;
import systems.dennis.shared.scopes.model.ScopeModel;

import java.util.Date;
import java.util.List;
import java.util.Optional;

public interface ActiveTokensRepo extends PaginationRepository<ActiveToken> {
    Optional<ActiveToken> findFirstByUserDataIdAndActiveIsTrueAndDueGreaterThanAndTypeAndScope(Long userDataId, Date date, String type, ScopeModel scope);
    Optional<ActiveToken> findFirstByTokenAndActiveIsTrueAndTypeAndScope(String token, String type, ScopeModel scope);

    List<ActiveToken> findByUserDataIdAndActiveIsTrueAndDueGreaterThan(Long userDataId, Date date);
}
