package systems.dennis.auth.form;

import lombok.Data;
import systems.dennis.shared.pojo_form.Checkable;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.UIAction;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.postgres.form.DefaultForm;

import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.*;

@Data
@PojoListView (actions = {"download",  "new", "settings"})
public class SubscriptionForm implements DefaultForm {
    @PojoListViewField(visible = false, searchable = false)
    @PojoFormElement(type = HIDDEN)
    private Long userDataId;

    @PojoFormElement(required = true)
    private String name;

    @PojoFormElement(type = TEXT_AREA)
    @PojoListViewField(widthInTable = "300px", searchable = true)
    private String description;

    @PojoFormElement(type = HIDDEN)
    @PojoListViewField(visible = false)
    private Long id;

    @PojoFormElement(type = CHECKBOX, checked = @Checkable(checked = true))
    private Boolean active;

    @PojoFormElement(type = CHECKBOX, checked = @Checkable(checked = true))
    @PojoListViewField( searchable = true)
    private Boolean allowMultiplePurchases;

    @PojoFormElement()

    private Long price;

    @PojoFormElement(required = true)
    private Long durationInDays = -1L;

    @PojoListViewField(showContent = false, actions = {@UIAction(component = "edit"), @UIAction(component = "delete", allowOnMultipleRows = true)})
    @PojoFormElement(visible = false)
    private int actions;
}
